<?php

namespace VM\FinancialStatementsBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use VM\ApiBundle\Entity\SummaryCompanyRound;
use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieInwestycjiDS;
use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieProdukcjiDS;
use VM\FinancialStatementsBundle\Services\FinancialStatementGame;
use VM\FinancialStatementsBundle\Services\Gra;
use VM\FinancialStatementsBundle\Services\Lokata;
use VM\FinancialStatementsBundle\Services\Reports\FullReport;
use VM\FinancialStatementsBundle\Services\Reports\SimpleReport;
use VM\AdminBundle\Controller\AbstractController;
use VM\FinancialStatementsBundle\Services\Reports\Svg\SvgChar;

class ReportController extends AbstractController
{
    public function indexAction()
    {
        $array = array(
            array('label' => 'Tura 1', 'value' => 2000000),
            array('label' => 'Tura 2', 'value' => 1830000),
            array('label' => 'Tura 3', 'value' => 830000),
            array('label' => 'Tura 4', 'value' => 1830000),
            array('label' => 'Tura 5', 'value' => 1630000),
            array('label' => 'Tura 6', 'value' => 1730000),
            array('label' => 'Tura 7', 'value' => 930000),
            array('label' => 'Tura 8', 'value' => 330000),
            array('label' => 'Tura 9', 'value' => 630000),
            array('label' => 'Tura 10', 'value' => 1030000),
        );


//        $SvgChar = new SvgChar();
//        $Svg = $SvgChar->create($array);
//        echo($Svg);
//        die();

        $apiGetter = $this->getApiGetter();
        $Company = $apiGetter->getUserCompanyOrFalse($this->getUser());
        $Round = $apiGetter->getUserActualRound($this->getUser());

//        $FinancialStatementGame = new FinancialStatementGame();
        $FinancialStatementGame = $this->get('vm_financial_statement_game');
        $data = $FinancialStatementGame->statement($Round,$Company);
        $data->companyName = $Company->getName();
        $data->grupName = $Company->getUserGroups()->getName();

//        $data = $this->generateData();
        $SimpleReport = new SimpleReport($data);


//        $apiGetter = $this->getApiGetter();
//        $Company = $apiGetter->getUserCompanyOrFalse($this->getUser());
//        $Round = $apiGetter->getUserActualRound($this->getUser());
//
//        $FinancialStatementGame = new FinancialStatementGame();
//        $data = $FinancialStatementGame->statement($Round,$Company);
////        $data = $this->generateData();
//        $SimpleReport = new SimpleReport($data);
//
        $SimpleReport->getPdf()->Output('simple_report.pdf');
//
        return $this->render('VMFinancialStatementsBundle:Default:index.html.twig', array());
    }

    public function fullReportAction($iteration)
    {
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($this->getUser());
        $SummaryCompanyRounds = $Company->getSummaryCompanyRound();
        /**
         * @var SummaryCompanyRound $SummaryCompanyRound
         */
        $CompanySummaryRound = null;
        foreach($SummaryCompanyRounds as $SummaryCompanyRound)
        {
            if($SummaryCompanyRound->getRound()->getSequence() == $iteration)
            {
                $CompanySummaryRound = $SummaryCompanyRound;
            }
        }
        $data = json_decode($CompanySummaryRound->getResults());
//        var_dump($data);
//        die();
        $data->companyName = $Company->getName();
        $data->groupName = $Company->getUserGroups()->getName();

        $FullReport = new FullReport($data, $iteration);

        $FullReport->getPdf()->Output('simple_report.pdf');

        return $this->render('VMFinancialStatementsBundle:Default:index.html.twig', array());
    }


    /**
     * @return mixed
     */
    protected function generateData()
    {
        $FinansowanieInwestycjiDS = new FinansowanieInwestycjiDS();
        $FinansowanieInwestycjiDS->naklady = 2000;
        $FinansowanieInwestycjiDS->procentAmortyzacji = 0.10;
        $FinansowanieInwestycjiDS->kapitalWlasny = 1000;
        $FinansowanieInwestycjiDS->kapitalObcy = 1000;
        $FinansowanieInwestycjiDS->czyKapitalWlasny = true;
        $FinansowanieInwestycjiDS->czyKredyt = true;
        $FinansowanieInwestycjiDS->czyLeasing = false;
        $FinansowanieInwestycjiDS->czyNaSrodkiTrwale = true;
        $FinansowanieInwestycjiDS->oprocentowanieKredytuLubLeasingu = 0.05;
        $FinansowanieInwestycjiDS->okresKredytuLubLeasingu = 5;
        $FinansowanieInwestycjiDS->ostatniaWplataLeasingu = 0;

        $FinansowanieProdukcjiDS = new FinansowanieProdukcjiDS();
        $FinansowanieProdukcjiDS->wielkoscRynku = 200000000;
        $FinansowanieProdukcjiDS->udzialWRynku = 0.03;
        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcjiDS->nakladyNaPiR = 0.07;
        $FinansowanieProdukcjiDS->nakladyNaInnowacje = 0.05;
        $FinansowanieProdukcjiDS->mozliwosciProdukcyjne = 1300000;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 300000;
            $FinansowanieProdukcjiDS->kosztyStale = array(
            'osobowe'=>array('q'=>10, 'kj'=>61200),
            'materialowe'=>array('q'=>1200, 'kj'=>6),
            'energia'=>array('q'=>36000, 'kj'=>0.6),
            'ubezpieczenia'=>array('q'=>1, 'kj'=>10000),
            'telekomunikacja'=>array('q'=>1, 'kj'=>72000),
            'podatkiLokalne'=>array('q'=>1, 'kj'=>30000),
            'oplatyBankowe'=>array('q'=>1, 'kj'=>1200),
        );
        $FinansowanieProdukcjiDS->kosztyZmienne = array(
            'osobowe'=>array('kjz'=>0.2, 'cenaJednostki'=>29.6511627907),
            'materialowe'=>array('kjz'=>0.5, 'cenaJednostki'=>3),
            'energia'=>array('kjz'=>2, 'cenaJednostki'=>0.6),
            'woda'=>array('kjz'=>0.15, 'cenaJednostki'=>7),
            'kosztyLogistyki'=>array('kjz'=>1, 'cenaJednostki'=>0.3),
        );
        $Lokata = new Lokata(30000, 0.04, 'moja1');

        $Gra = new Gra(2014);

        $Gra->addFinansowanieInwestycji($FinansowanieInwestycjiDS);
        $Gra->addFinansowanieInwestycji($FinansowanieInwestycjiDS);

//        $Gra->ad($Lokata);
//        $Lokata = new Lokata(30000, 0.04, 'moja2');
//
//        $Gra->addLokata($Lokata);
//        $Lokata = new Lokata(30000, 0.04, 'moja3');
//
//        $Gra->addLokata($Lokata);
//        $Lokata = new Lokata(30000, 0.04, 'moja4');
//
//        $Gra->addLokata($Lokata);


        $przeliczone = $Gra->evalAndGetNextIteration($FinansowanieProdukcjiDS);

        $FinansowanieProdukcjiDS->cenaProduktu = 24;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 320000;

        $przeliczone = $Gra->evalAndGetNextIteration($FinansowanieProdukcjiDS);

        $FinansowanieProdukcjiDS->cenaProduktu = 23;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 340000;

        $przeliczone = $Gra->evalAndGetNextIteration($FinansowanieProdukcjiDS);

        $FinansowanieProdukcjiDS->cenaProduktu = 22;
        $FinansowanieProdukcjiDS->planowanaProdukcja = 360000;

        $przeliczone = $Gra->evalAndGetNextIteration($FinansowanieProdukcjiDS);

        return $przeliczone;
    }
}